<?php

if ( ! function_exists( 'edgtf_core_map_testimonials_meta' ) ) {
	function edgtf_core_map_testimonials_meta() {
		$testimonial_meta_box = haar_edge_create_meta_box(
			array(
				'scope' => array( 'testimonials' ),
				'title' => esc_html__( 'Testimonial', 'edgtf-core' ),
				'name'  => 'testimonial_meta'
			)
		);
		
		haar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_testimonial_title',
				'type'        => 'text',
				'label'       => esc_html__( 'Title', 'edgtf-core' ),
				'description' => esc_html__( 'Enter testimonial title', 'edgtf-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);

        haar_edge_create_meta_box_field(
            array(
                'name'        => 'edgtf_testimonial_title_emphasize_words',
                'type'        => 'text',
                'label'       => esc_html__( 'Emphasize Words in Title', 'edgtf-core' ),
                'description' => esc_html__( 'Enter the positions of the words you would like to Emphasize. Separate the positions with commas (e.g. if you would like the first, third, and fourth word to be emphasized, you would enter "1,3,4").', 'edgtf-core' ),
                'parent'      => $testimonial_meta_box,
            )
        );

        haar_edge_create_meta_box_field(
            array(
                'name'          => 'edgtf_testimonial_title_underscore',
                'type'          => 'select',
                'default_value' => '',
                'label'         => esc_html__( 'Enable Underscore', 'haar' ),
                'description'   => esc_html__( 'Enable Underscore after the Title', 'haar' ),
                'options'       => haar_edge_get_yes_no_select_array(),
                'parent'        => $testimonial_meta_box
            )
        );
		
		haar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_testimonial_text',
				'type'        => 'text',
				'label'       => esc_html__( 'Text', 'edgtf-core' ),
				'description' => esc_html__( 'Enter testimonial text', 'edgtf-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
		
		haar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_testimonial_author',
				'type'        => 'text',
				'label'       => esc_html__( 'Author', 'edgtf-core' ),
				'description' => esc_html__( 'Enter author name', 'edgtf-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
		
		haar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_testimonial_author_position',
				'type'        => 'text',
				'label'       => esc_html__( 'Author Position', 'edgtf-core' ),
				'description' => esc_html__( 'Enter author job position', 'edgtf-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
	}
	
	add_action( 'haar_edge_meta_boxes_map', 'edgtf_core_map_testimonials_meta', 95 );
}